package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.CloneCraft;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class Blood {
	
	ItemStack stack;
	
	public Blood(ItemStack stack){
		load(stack.getTagCompound());
		this.stack = stack;
	}
	
	public void save(){
		stack.setTagCompound(save(stack.getTagCompound()));
	}
	
	public NBTTagCompound save(NBTTagCompound nbt){
		if(nbt == null)nbt = new NBTTagCompound();
		nbt.setInteger("entityId", entityId);
		return nbt;
	}
	
	public void load(NBTTagCompound nbt){
		entityId = nbt.getInteger("entityId");
	}
	
	int entityId = -1;

	public String getCurrentEntityName(){
		return getEntityName(entityId);
	}
	
	public String getEntityName(int id){
		if(id == CloneCraft.cloneId){
			return "Human";
		}
		return EntityList.getStringFromID(id);
	}
	public String getDisplayName(String itemName, String containing){
		if(entityId > -1){
			String currentEntity = getCurrentEntityName();
			return currentEntity + " " + containing;
		}
		return "Empty " + itemName;
	}
	
	public int getColour(){
		return getColour(entityId);
	}
	
	public int getColour(int entityID){
		if(entityID == CloneCraft.cloneId){
			return DNA.bloodColour;
		}
		if(EntityList.entityEggs.containsKey(entityID)){
			return ((EntityEggInfo)EntityList.entityEggs.get(entityID)).primaryColor;
		}
		return 0xffffffff;
	}
}
